#include <bits/stdc++.h>
using namespace std;
using ll = long long;
struct Node {
    ll key; 
    int id;
    uint32_t pri;
    Node *l, *r;
    int sz;
    ll sum;
    Node(ll k=0, int i=0): key(k), id(i), pri(((uint32_t)rand()<<16) ^ rand()), l(nullptr), r(nullptr), sz(1), sum(k) {}
};
int sz(Node* t){ return t ? t->sz : 0; }
ll sumv(Node* t){ return t ? t->sum : 0; }
void upd(Node* t){ if(t){ t->sz = 1 + sz(t->l) + sz(t->r); t->sum = t->key + sumv(t->l) + sumv(t->r); } }

inline bool less_pair(ll key, int id, Node* t){
    if(!t) return false;
    if(key != t->key) return key < t->key;
    return id < t->id;
}

void split(Node* t, ll key, int id, Node*& a, Node*& b){
    if(!t){ a = b = nullptr; return; }
    if(t->key < key || (t->key == key && t->id <= id)){
        split(t->r, key, id, t->r, b);
        a = t;
        upd(a);
    } else {
        split(t->l, key, id, a, t->l);
        b = t;
        upd(b);
    }
}

Node* merge(Node* a, Node* b){
    if(!a) return b;
    if(!b) return a;
    if(a->pri < b->pri){
        a->r = merge(a->r, b);
        upd(a);
        return a;
    } else {
        b->l = merge(a, b->l);
        upd(b);
        return b;
    }
}

void insert(Node*& t, Node* it){
    if(!t){ t = it; return; }
    if(it->pri < t->pri){
        split(t, it->key, it->id, it->l, it->r);
        t = it;
    } else {
        if( less_pair(it->key, it->id, t) ) insert(t->l, it);
        else insert(t->r, it);
    }
    upd(t);
}

void erase(Node*& t, ll key, int id){
    if(!t) return;
    if(t->key == key && t->id == id){
        Node* cur = t;
        t = merge(t->l, t->r);
        delete cur;
    } else {
        if( key < t->key || (key == t->key && id < t->id) ) erase(t->l, key, id);
        else erase(t->r, key, id);
    }
    upd(t);
}

ll sum_k_largest(Node* t, int k){
    if(!t || k <= 0) return 0;
    int rs = sz(t->r);
    if(rs >= k){
        return sum_k_largest(t->r, k);
    } else {
        ll res = sumv(t->r);
        if(rs + 1 == k){
            res += t->key;
            return res;
        } else {
            res += t->key;
            res += sum_k_largest(t->l, k - rs - 1);
            return res;
        }
    }
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    srand(1234567);
    int N, Q;
    if(!(cin >> N >> Q)) return 0;
    vector<int> a(N+1);
    for(int i=1;i<=N;i++) cin >> a[i];
    vector<int> cnt(N+1,0);
    ll total_sum = 0;
    for(int i=1;i<=N;i++){ cnt[a[i]]++; total_sum += a[i]; }

    Node* root = nullptr;
    for(int v=1; v<=N; ++v){
        ll c = 1LL * v * cnt[v];
        Node* nd = new Node(c, v);
        insert(root, nd);
    }

    for(int qi=0; qi<Q; ++qi){
        int t; cin >> t;
        if(t == 1){
            int x; cin >> x;
            int T = N - x;
            if(T <= 0){
                cout << total_sum << '\n';
            } else {
                if(T > N) T = N;
                ll removed = sum_k_largest(root, T);
                cout << (total_sum - removed) << '\n';
            }
        } else {
            int pos, y; cin >> pos >> y;
            int old = a[pos];
            if(old == y) { a[pos] = y; continue; }
            ll old_contrib_before = 1LL * old * cnt[old];
            erase(root, old_contrib_before, old);
            cnt[old]--;
            ll old_contrib_after = 1LL * old * cnt[old];
            insert(root, new Node(old_contrib_after, old));
            ll new_contrib_before = 1LL * y * cnt[y];
            erase(root, new_contrib_before, y);
            cnt[y]++;
            ll new_contrib_after = 1LL * y * cnt[y];
            insert(root, new Node(new_contrib_after, y));
            a[pos] = y;
            total_sum += (ll)y - (ll)old;
        }
    }

    return 0;
}